///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Texture export method.
 *	This method is called once for each exported texture.
 *	\param		texture		[in] a structure filled with current texture information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ASCIIFormat::ExportTexture(const TextureDescriptor& texture)
{
	// Export database management information
	mTexmaps.StoreASCII("\n///////////////////////////////////////////////////////////////////////////////////////////////////////////////////\n").StoreASCII("Texture: ");
	mTexmaps.StoreASCII((const char*)texture.mName);

	// We only export the texture's name in ascii, as well as the texture ID as a reminder.
	mTexmaps.StoreASCII("\n\nTextureID:    ").StoreASCII(texture.mObjectID);

	// The cropping values
	mTexmaps
		.StoreASCII("\n\nCropping values:\n")
		.StoreASCII("OffsetU: ").StoreASCII(texture.mCValues.OffsetU)
		.StoreASCII("\nOffsetV: ").StoreASCII(texture.mCValues.OffsetV)
		.StoreASCII("\nScaleU: ").StoreASCII(texture.mCValues.ScaleU)
		.StoreASCII("\nScaleV: ").StoreASCII(texture.mCValues.ScaleV)
		.StoreASCII("\n");

	// The texture matrix
	mTexmaps
		.StoreASCII("\nTexture matrix:\n")
		.StoreASCII(texture.mTMtx.m[0][0]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[0][1]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[0][2]).StoreASCII("\n")
		.StoreASCII(texture.mTMtx.m[1][0]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[1][1]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[1][2]).StoreASCII("\n")
		.StoreASCII(texture.mTMtx.m[2][0]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[2][1]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[2][2]).StoreASCII("\n")
		.StoreASCII(texture.mTMtx.m[3][0]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[3][1]).StoreASCII(" ").StoreASCII(texture.mTMtx.m[3][2]).StoreASCII("\n\n");

	return true;
}

